#!/bin/sh
echo "Checking if device nodes need to be recreated..."
RECREATE_FLAG=0
event0=$(ls -l /dev/input/event0 | awk '{print $6}')
if [ $event0 != 64 ]
then
  RECREATE_FLAG=1
fi
event1=$(ls -l /dev/input/event1 | awk '{print $6}')
if [ $event1 != 65 ]
then
  RECREATE_FLAG=1
fi
input0=$(ls -l /dev/input/input0 | awk '{print $6}')
if [ $input0 != 64 ]
then
  RECREATE_FLAG=1
fi
input1=$(ls -l /dev/input/input1 | awk '{print $6}')
if [ $input1 != 65 ]
then
  RECREATE_FLAG=1
fi
if [ $RECREATE_FLAG = 1 ]
then
  echo "Recreating device nodes..."
  mount -n -o remount -w /dev/mmcblk0p2 /
  rm -rf /dev/input/*
  mknod /dev/input/event0 c 13 64 &&
  mknod /dev/input/event1 c 13 65 &&
  mknod /dev/input/input0 c 13 64 &&
  mknod /dev/input/input1 c 13 65 &&
  sync &&
  mount -n -o remount -r /dev/mmcblk0p2 /
  echo "Device nodes recreated successfully."
else
  echo "Device nodes are OK. Nothing to be done."
fi

