#!/bin/sh
if [ -d /mnt/data  ] && [ -e /dev/mmcblk0p3 ]
then
  mount -n -t ext4 -w /dev/mmcblk0p3 /mnt/data
  if [ -e /mnt/rwfs/data/$WPD_CFG_FILE ] && [ -d /mnt/data ]
  then
    echo "Saving WPD app config file"
    rsync -azv --progress /mnt/rwfs/data/$WPD_CFG_FILE /mnt/data/
    md5sum /mnt/fat/wpd_app/data/$WPD_CFG_FILE > /mnt/data/$WPD_CFG_FILE.md5
  fi
  sync
  umount /dev/mmcblk0p3
else
  sync
  mount -n -o remount -r /dev/mmcblk0p1 /mnt/fat
fi
