#!/bin/sh
if [ -d /usr/var/cache/fontconfig ]
then
echo "Caching fonts..." &&
if [ "$(ls -A /usr/var/cache/fontconfig)" ]; then
    echo "Fonts already cached. Done nothing."
else
  mount -n -o remount -w /dev/mmcblk0p2 / &&
  echo -en "stop" > /proc/nxw_wdog &&
  find /usr/share/fonts/ -exec touch {} \; &&
  fc-cache /usr/share/fonts &&
  sync &&
  echo -en "start" > /proc/nxw_wdog &&
  mount -n -o remount -r /dev/mmcblk0p2 / &&
  echo "Done. Fonts cached."
fi
fi
