#!/bin/sh
if [ -d /mnt/data  ] && [ -e /dev/mmcblk0p3 ]
then
  DATA_CFG_FILE_EXISTS=0
  DATA_UP2DATE_FILE_EXISTS=0
  mount -n -t ext4 -r /dev/mmcblk0p3 /mnt/data &&
  if [ -f /mnt/data/$WPD_UP2DATE_FILE ]
  then
    DATA_UP2DATE_FILE_EXISTS=1
  fi
  if [ -f /mnt/data/$WPD_CFG_FILE ]
  then
    DATA_CFG_FILE_EXISTS=1
  fi
  umount /dev/mmcblk0p3 &&
  if [ $DATA_UP2DATE_FILE_EXISTS = 1 ]						# jesli plik up2date (plik kontrolny 2) istnieje
  then
    echo "Checking if WPD app config file is up-to-date" && 
    u2d_md5sum1f=$(md5sum /mnt/rwfs/data/$WPD_CFG_FILE) &&				# generowanie sumy MD5 z pliku konfiguracyjnego bezpiecznego
    mount -n -t ext4 -r /dev/mmcblk0p3 /mnt/data &&					# montowanie partycji roboczej do zapisu (EXT4)
    u2d_md5sum2f=$(cat /mnt/data/$WPD_UP2DATE_FILE) &&				# odczyt sumy MD5 z pliku kontrolnego 2
    sync &&										# wrazie co... "przede wszystkim nie szkodzic" ;)
    umount /dev/mmcblk0p3 &&								# odmontowanie partycji roboczej
    u2d_md5sum1="$(echo "$u2d_md5sum1f" | awk '{print $1}')" &&			# wyluskanie czystej sumy kontrolnej 1 (bez dodatkow)
    u2d_md5sum2="$(echo "$u2d_md5sum2f" | awk '{print $1}')" &&			# wyluskanie czystej sumy kontrolnej 2 (bez dodatkow)
    echo "UP-TO-DATE MD5SUM_1: $u2d_md5sum1" &&
    echo "UP-TO-DATE MD5SUM_2: $u2d_md5sum2" &&
    if [ "$u2d_md5sum1" = "$u2d_md5sum2" ]						# jesli sumy kontrolne sie zgadzaja, oznacza to, ze plik bezpieczny nie jest nowszy niz plik roboczy
    then
      echo "WPD app config file is up-to-date"
    else										# jesli sumy kontrolne sie nie zgadzaja - trzeba zaktualizowac plik roboczy
      echo "WPD app config file requires update" &&
      /bin/sh save_config.sh &&							# aktualizacja pliku roboczego plikiem bezpiecznym i utworzenie pliku kontrolnego 1
      mount -n -t ext4 -w /dev/mmcblk0p3 /mnt/data &&					# montowanie partycji roboczej do zapisu (EXT4)
      md5sum /mnt/rwfs/data/$WPD_CFG_FILE > /mnt/data/$WPD_UP2DATE_FILE &&	# utworzenie pliku kontrolnego 2 na podstawie nowego pliku bezpiecznego
      sync &&										# wymuszenie zrzucenia bufora na dysk (dla pewnosci, ze wszystko sie zapisze)
      umount /dev/mmcblk0p3 &&							# odmontowanie partycji roboczej
      echo "WPD app config file updated"
    fi
  else											# jesli nie ma pliku up2date ==> uszkodzona partycja || pierwsze uruchomienie 
      echo "WPD app config file requires update" &&
      echo -e "--\033[33m!!!\033[0m-----------------------------------" > /dev/tty1
      echo -en "\033[33m This is the first run or working-copy\x0a\x0d\033[0m" > /dev/tty1
      echo -en "\033[33m partition is broken.\x0a\x0d\033[0m" > /dev/tty1
      echo -en "\033[33m It needs to be (re)created.\x0a\x0d\033[0m" > /dev/tty1
      echo -e "----------------------------------------" > /dev/tty1
      echo -en "Press knob to proceed...\x0a\x0d" > /dev/tty1
      echo -en "stop" > /proc/nxw_wdog
      read -n1 < /dev/input/event1
      echo -en "start" > /proc/nxw_wdog
      echo -en "..formatting" > /dev/tty1
      mkfs.ext4 -LDataFS /dev/mmcblk0p3 &&						# format partycji (w przypadku pierwszego uruchomienia niepotrzebny, ale i nie zaszkodzi)
      echo -e " [\033[32mOK\033[0m]" > /dev/tty1
      echo -en "..copying data" > /dev/tty1
      /bin/sh save_config.sh &&							# tworzenie kopii roboczych plikow konfiguracyjnych oraz plikow kontrolnych (md5sum)
      mount -n -t ext4 -w /dev/mmcblk0p3 /mnt/data &&					# montowanie partycji roboczej do zapisu (EXT4)
      md5sum /mnt/rwfs/data/$WPD_CFG_FILE > /mnt/data/$WPD_UP2DATE_FILE &&	# utworzenie 2-go pliku kontrolnego
      sync &&										# wymuszenie zrzucenia bufora na dysk (dla pewnosci, ze wszystko sie zapisze)
      umount /dev/mmcblk0p3 &&							# odmontowanie partycji roboczej
      echo -e " [\033[32mOK\033[0m]" > /dev/tty1
      echo -en "Working-copy partition is ready.\x0a\x0d" > /dev/tty1
      sleep 2 &&
      echo "WPD app config file updated"
  fi
  if [ -f /mnt/fat/wpd_app/data/$WPD_CFG_FILE ] && [ $DATA_CFG_FILE_EXISTS = 0 ]	# jesli plik bezpieczny istnieje, a plik roboczy nie istnieje
  then
    /bin/sh save_config.sh								# tworzymy plik roboczy na podstawie pliku bezpiecznego
  else
    /bin/sh load_config.sh								# w przeciwnym wypadku ladujemy do ramdisku plik roboczy (powyzej zadbane zostalo aby nie byl starszy niz bazpieczny)
  fi
fi
