#!/bin/sh
if [ -d /mnt/data  ] && [ -e /dev/mmcblk0p3 ]
then
  mount -n -t ext4 -r /dev/mmcblk0p3 /mnt/data
  if [ -e /mnt/data/$WPD_CFG_FILE.md5 ]						    # jesli plik kontrolny 1 istnieje
  then
    echo "Checking WPD app config file MD5 SUM..." 
    md5sum1f=$(md5sum /mnt/data/$WPD_CFG_FILE)
    md5sum2f=$(cat /mnt/data/$WPD_CFG_FILE.md5)
    md5sum1="$(echo "$md5sum1f" | awk '{print $1}')"
    md5sum2="$(echo "$md5sum2f" | awk '{print $1}')"
    echo "MD5SUM_1: $md5sum1"
    echo "MD5SUM_2: $md5sum2"
    if [ "$md5sum1" = "$md5sum2" ]
    then
      echo "WPD app config file MD5 SUM matches" 
      if [ -e /mnt/data/$WPD_CFG_FILE ] && [ -d /mnt/rwfs/data ]
      then
        echo "Loading WPD app config file..."
        rsync -azv --progress /mnt/data/$WPD_CFG_FILE /mnt/rwfs/data/
        echo "WPD app config file loaded successfully"
      fi
    else
      echo "WPD app config file has wrong MD5 SUM"
      echo "Syncing aborted"
    fi
    sync &&
    umount /dev/mmcblk0p3
  else 										    # jesli plik kontrolny 1 nie istnieje ==> uszkodzona partycja (pierwsze uruchomienie juz bylo)
    echo "WPD app config MD5 SUM file (/mnt/data/$WPD_CFG_FILE.md5): no such file" 
    echo "Syncing aborted. Trying to repair..."
    sync &&
    umount /dev/mmcblk0p3 &&
    mkfs.ext4 -LDataFS /dev/mmcblk0p3 &&						    # format partycji
    /bin/sh save_config.sh &&								    # odtwarzanie kopii roboczych plikow konfiguracyjnych oraz plikow kontrolnych (md5sum)
    mount -n -t ext4 -w /dev/mmcblk0p3 /mnt/data &&					    # montowanie partycji roboczej do zapisu (EXT4)
    md5sum /mnt/rwfs/data/$WPD_CFG_FILE > /mnt/data/$WPD_UP2DATE_FILE &&		    # utworzenie 2-go pliku kontrolnego
    sync &&										    # wymuszenie zrzucenia bufora na dysk (dla pewnosci, ze wszystko sie zapisze)
    umount /dev/mmcblk0p3 &&								    # odmontowanie partycji roboczej
    echo "Working copy has been restored."						    # nie trzeba ponawiac probu ladowania pliku roboczego poniewaz jest teraz == plikowi bezpiecznemu
 fi
fi

